/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.ras;

import ibm.nways.ras.ErrorLogServerHandle;
import ibm.nways.ras.TracesResources;
import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class Traces {
    public static boolean enabled;
    public static long traceMask;
    public static int logSize;
    public static int maxLogSize;
    private static ErrorLogServerHandle server;
    protected static String indentation;
    private static TracesResources trRes;
    private static String NLSError;
    private static String NLSWarning;
    private static String NLSInformation;
    private static ByteArrayOutputStream exOutStream;
    private static PrintWriter exceptionWriter;
    public static final long FLAG1 = 1L;
    public static final long FLAG2 = 2L;
    public static final long FLAG3 = 4L;
    public static final long FLAG4 = 8L;
    public static final long FLAG5 = 16L;
    public static final long FLAG6 = 32L;
    public static final long FLAG7 = 64L;
    public static final long FLAG8 = 128L;
    public static final long FLAG9 = 256L;
    public static final long FLAG10 = 512L;
    public static final long FLAG11 = 1024L;
    public static final long FLAG12 = 2048L;
    public static final long FLAG13 = 4096L;
    public static final long FLAG14 = 8192L;
    public static final long FLAG15 = 16384L;
    public static final long FLAG16 = 32768L;
    public static final long FLAG17 = 65536L;
    public static final long FLAG18 = 131072L;
    public static final long FLAG19 = 262144L;
    public static final long FLAG20 = 524288L;
    public static final long FLAG21 = 0x100000L;
    public static final long FLAG22 = 0x200000L;
    public static final long FLAG23 = 0x400000L;
    public static final long FLAG24 = 0x800000L;
    public static final long FLAG25 = 0x1000000L;
    public static final long FLAG26 = 0x2000000L;
    public static final long FLAG27 = 0x4000000L;
    public static final long FLAG28 = 0x8000000L;
    public static final long FLAG29 = 0x10000000L;
    public static final long FLAG30 = 0x20000000L;
    public static final long FLAG31 = 0x40000000L;
    public static final long FLAG32 = Integer.MIN_VALUE;
    public static final long FLAG_ALL = -1L;

    public static void initializeTraces(String[] stringArray) throws RemoteException {
        String string = "localhost";
        int n = 1099;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2];
            if (string2.equals("-debug")) {
                enabled = true;
                string2 = stringArray[n2 + 1];
                if (string2.equals("FLAG_ALL")) {
                    traceMask = -1L;
                    ++n2;
                } else if (string2.startsWith("FLAG")) {
                    String string3 = string2.substring(4);
                    try {
                        traceMask |= (long)(1 << Integer.parseInt(string3) - 1);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    ++n2;
                }
            } else if (string2.equals("-servername")) {
                string = stringArray[n2 + 1];
                ++n2;
            } else if (string2.equals("-portnum")) {
                try {
                    n = Integer.parseInt(stringArray[n2 + 1]);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 1099;
                }
            }
            ++n2;
        }
        Traces.initialize(string, n);
    }

    public static void initializeTraces(Applet applet) throws RemoteException {
        int n;
        String string = applet.getParameter("debug");
        String string2 = applet.getParameter("port_num");
        if (string != null && string.length() > 0) {
            enabled = true;
            if (string.equals("FLAG_ALL")) {
                traceMask = -1L;
            } else if (string.startsWith("FLAG")) {
                String string3 = string.substring(4);
                try {
                    traceMask |= (long)(1 << Integer.parseInt(string3) - 1);
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        try {
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = 1099;
        }
        Traces.initialize(applet.getDocumentBase().getHost(), n);
    }

    public static void initializeTraces(String string, int n) throws RemoteException {
        Traces.initialize(string, n);
    }

    private static void initialize(String string, int n) throws RemoteException {
        trRes = (TracesResources)ResourceBundle.getBundle("ibm.nways.ras.TracesResources", Locale.getDefault());
        NLSError = Traces.getNLSString("error");
        NLSWarning = Traces.getNLSString("warning");
        NLSInformation = Traces.getNLSString("information");
        try {
            String string2 = "rmi://" + string + ":" + n + "/ErrorLog";
            server = (ErrorLogServerHandle)Naming.lookup(string2);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RemoteException("url is not valid", malformedURLException);
        }
        catch (NotBoundException notBoundException) {
            throw new RemoteException("name ErrorLog is not bound", notBoundException);
        }
        if (enabled) {
            Traces.traceMessage("Tracing initiated");
        }
        exOutStream = new ByteArrayOutputStream(800);
        exceptionWriter = new PrintWriter(exOutStream, true);
    }

    private static String getNLSString(String string) {
        String string2 = null;
        try {
            string2 = trRes.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            return string;
        }
    }

    private static void logText(Object object, String string, String string2) {
        String string3 = string;
        string3 = String.valueOf(string3) + "(" + object.hashCode() + "):" + string2;
        try {
            if (enabled) {
                server.trace(string3);
            }
            server.log(string3);
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to log message" + string2);
            return;
        }
    }

    private static String getClassName(Object object) {
        String string = object.getClass().getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        if (stringTokenizer.countTokens() > 1) {
            while (stringTokenizer.countTokens() > 0) {
                string = stringTokenizer.nextToken();
            }
        }
        return string;
    }

    public static boolean isEnabled(long l) {
        return (traceMask & l) == l;
    }

    public static void enterStaticMethod(String string) {
        try {
            server.trace("Thread " + Thread.currentThread().getName() + indentation + "-->" + string);
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace message " + string);
        }
        indentation = String.valueOf(indentation) + "   ";
    }

    public static void exitStaticMethod(String string) {
        indentation = indentation.substring(0, indentation.length() - 3);
        try {
            server.trace("Thread " + Thread.currentThread().getName() + indentation + "<--" + string);
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace message " + string);
            return;
        }
    }

    public static void enterMethod(Object object, String string) {
        String string2 = Traces.getClassName(object);
        try {
            server.trace("Thread " + Thread.currentThread().getName() + indentation + "-->" + string2 + "." + string + " (" + object.hashCode() + ") ");
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace message " + string);
        }
        indentation = String.valueOf(indentation) + "   ";
    }

    public static void exitMethod(Object object, String string) {
        indentation = indentation.substring(0, indentation.length() - 3);
        String string2 = Traces.getClassName(object);
        try {
            server.trace("Thread " + Thread.currentThread().getName() + indentation + "<--" + string2 + "." + string + " (" + object.hashCode() + ")");
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace message " + string);
            return;
        }
    }

    public static void traceMessage(String string) {
        try {
            server.trace(String.valueOf(indentation) + string);
            return;
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace message " + string);
            return;
        }
    }

    public static void logError(Object object, String string) {
        Traces.logText(object, NLSError, string);
    }

    public static void logInformation(Object object, String string) {
        Traces.logText(object, NLSInformation, string);
    }

    public static void logWarning(Object object, String string) {
        Traces.logText(object, NLSWarning, string);
    }

    public static void logException(Exception exception) {
        exceptionWriter.println("Thread " + Thread.currentThread().getName());
        exceptionWriter.println(exception.toString());
        exceptionWriter.println(exception.getMessage());
        exception.printStackTrace(exceptionWriter);
        try {
            String string = exOutStream.toString();
            if (enabled) {
                server.trace(string);
            }
            server.log(string);
        }
        catch (RemoteException remoteException) {
            System.out.println("Failed to trace exception " + exception.toString());
        }
        exOutStream.reset();
    }

    public static void setTraceStatus(boolean bl) {
        enabled = bl;
    }

    public static void flush() {
        try {
            server.flush();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    static {
        maxLogSize = 1000000;
        indentation = new String("");
    }
}

